﻿using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Reflection;


namespace mtweb
{
  
//////////////////////////////////////////////////////////////////////////

public partial class DefaultPage : System.Web.UI.Page
{
  // Fields


  /////////////////////////////////////////////////////////
  // Events

  protected override void OnInit(EventArgs e)
  {
    base.OnInit(e);
    ScriptManager.GetCurrent(Page).Navigate += OnNavigate;

    // Append "?" to the default form action.
    // Needed to get AddHistoryPoint() working on Opera.
    Form1.Attributes["action"] = Request.FilePath + "?";
  }


  protected void Page_Load(object sender, EventArgs e)
  {
    // Load or reload a UserControl:
    string file = this.TrackedControl;

    if (!string.IsNullOrEmpty(file)) {
      if (IsPostBack) ReloadContent();
    }

    else {
      file = "~/Controls/Home.ascx";
      if (!IsPostBack) LoadContent(file, null);
      else throw new Exception("Page_Load(): invalid state");  // dbg
    }
  }


  // History event handler
  protected void OnNavigate(object sender, HistoryEventArgs e)
  {
    // Page
    string page = e.State["UCPage"];
    if (page == null) page = "~/Controls/Home.ascx";

    // Parameters
    ParameterCollection pc = null;
    string s = e.State["Params"];
    if (s != null) pc = Util.DeserializePC(s);

    // Load
    LoadContent(page, pc);
  }


  /////////////////////////////////////////////////////////
  // Properties

  protected string TrackedControl 
  {
    get {
      return ViewState["TrackedControl"] as string;
    }
    set {
      if (value == null) ViewState.Remove("TrackedControl");
      else ViewState["TrackedControl"] = value; 
    }
  }


  /////////////////////////////////////////////////////////
  // Content management

  // Load a new content
  public DControl LoadContent(string file, ParameterCollection pc)
  {
    // Remove all controls
    PlaceHolderAdminData.Controls.Clear();
    if (string.IsNullOrEmpty(file)) return null;
    
    // The return value
    DControl dc = null;

    // Load the control
    try {
      dc = DControl.LoadUC<DControl>(file, this);
      if (dc == null) throw new Exception();
    }
    catch (Exception ex) {
      string msg = "Couldn't load " + file + ". " + ex.Message;
      throw new Exception(msg);
    }

    // Save as tracked control
    TrackedControl = file;

    // Pass on parameters
    if (pc != null) dc.Params = pc;

    // Insert the new control
    PlaceHolderAdminData.Controls.Add(dc);

    // Add history points
    ScriptManager sm = ScriptManager.GetCurrent(Page);
    if (sm.IsInAsyncPostBack && !sm.IsNavigating)
    {
      sm.AddHistoryPoint("UCPage", file);
      sm.AddHistoryPoint("Params", Util.SerializePC(pc));
    }

    return dc;
  }


  // Reload content on postback
  public DControl ReloadContent()
  {
    // Get the tracked control
    string file = this.TrackedControl;

    // Error?
    if (string.IsNullOrEmpty(file)) {
      string msg = "Tracked control null or empty";
      throw new Exception(msg);
    }

    // The return value
    DControl dc = null;

    // Load the control
    try {
      dc = DControl.LoadUC<DControl>(file, this);
      if (dc == null) throw new Exception();
    }
    catch (Exception ex) {
      string msg = "Couldn't load " + file + ". " + ex.Message;
      throw new Exception(msg);
    }

    // Insert the new control
    PlaceHolderAdminData.Controls.Clear();
    PlaceHolderAdminData.Controls.Add(dc);

    return dc;
  }


  //
  public void CloseContent()
  {
    PlaceHolderAdminData.Controls.Clear();
    UpdatePanelAdminData.Update();
  }


  ///////////////////////////////////////////////
  // Click handlers

  protected void OnMenuClick(object sender, CommandEventArgs e)
  {
    string from = ((Control)sender).ClientID;
    string cmd = e.CommandName;
    string arg = e.CommandArgument as string;

    // Parameters for LoadContent()
    ParameterCollection pc = new ParameterCollection();
    pc.Add(new Parameter("CommandArgument", TypeCode.String, arg));

    if (!string.IsNullOrEmpty(cmd)) {
      LoadContent(cmd, pc);
    }
  }


  protected void ImageLogo_Click(object sender, ImageClickEventArgs e)
  {
    LoadContent("~/Controls/Home.ascx", null);
  }



  ///////////////////////////////////////////////
  // Excpetion handling

  // Pass on the errors from the UpdatePanels
  protected void OnAsyncPostbackError(object sender, AsyncPostBackErrorEventArgs e)
  {
    MethodInfo mi = typeof(Exception).GetMethod("InternalPreserveStackTrace",
                    BindingFlags.Instance | BindingFlags.NonPublic);

    mi.Invoke(e.Exception, null);
    throw e.Exception;
  }


}  // class
}  // namespace
